<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader;

use Core\Model\Helpers\BaseService;
use Core\Model\Helpers\Traits\TTranslator;
use Core\Model\TemplateReader\Providers\ITemplateTextType;

class TemplateTextTypesCollection extends BaseService
{
	use TTranslator;

	/** @var ITemplateTextType[] */
	private $itemsList = [];

	public function __construct()
	{
	}

	/**
	 * @param $type
	 *
	 * @return null|ITemplateTextType
	 */
	public function getItemByType($type)
	{
		return $this->itemsList[$type] ?? null;
	}

	/**
	 * @return array|ITemplateTextType[]
	 */
	public function getItems()
	{
		return $this->itemsList;
	}

	/**
	 * Voláno při generování containeru
	 *
	 * @param ITemplateTextType[] $items
	 */
	public function setItems($items)
	{
		foreach ($items as $item) {
			/** @var $item ITemplateTextType */
			$this->itemsList[$item->getType()] = $item;
		}
	}
}