<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid;

use Core\Model\UI\DataGrid\Column;
use Nette;
use Ublaboo\DataGrid\DataGrid;

class BaseDataGrid extends DataGrid
{
	/** @var string */
	protected $tableClass = '';

	/** @var string */
	protected $sortableGroup;

	public function __construct(Nette\ComponentModel\IContainer $parent = null, $name = null)
	{
		parent::__construct($parent, $name);
		//		$this->setItemsPerPageList([10, 20, 50, 100, 1000, 'all']);
		$this->setDefaultPerPage(20);
		$this->setRefreshUrl(false);
		$this->setRememberState(false);

		$this->setTemplateFile(__DIR__ . '/templates/datagrid.latte');

		$this->onAnchor[] = function() {
			$this->getTemplate()->newTemplate = __DIR__ . '/templates/datagrid.latte';
		};
	}

	public function render()
	{
		$this->template->tableClass    = $this->tableClass;
		$this->template->sortableGroup = $this->sortableGroup;
		parent::render();
	}

	public function addAction($key, $name, $href = null, array $params = null)
	{
		$this->addActionCheck($key);

		$href = $href ?: $key;

		if ($params === null) {
			$params = [$this->primary_key];
		}

		$control = $this->actions[$key] = new Column\Action($this, $href, $name, $params);

		return $control;
	}

	/*******************************************************************************************************************
	 * ==================  Columns
	 */

	/**
	 * @param string $key
	 * @param string $name
	 * @param null   $column
	 *
	 * @return \Ublaboo\DataGrid\Column\Column|Column\ColumnStatus
	 * @throws \Ublaboo\DataGrid\Exception\DataGridException
	 */
	public function addColumnStatus($key, $name, $column = null)
	{
		$this->addColumnCheck($key);
		$column = $column ?: $key;

		return $this->addColumn($key, new Column\ColumnStatus($this, $key, $column, $name));
	}

	/**
	 * @param      $key
	 * @param      $name
	 * @param null $column
	 *
	 * @return \Ublaboo\DataGrid\Column\Column|Column\ColumnPosition
	 */
	public function addColumnPosition($key, $name, $column = null)
	{
		$column = $column ?: $key;

		return $this->addColumn($key, new Column\ColumnPosition($this, $key, $column, $name));
	}

	/*******************************************************************************************************************
	 * ==================  Setters
	 */

	public function setTableClass($class)
	{
		$this->tableClass = $class;

		return $this;
	}

	public function setSortableGroup($group)
	{
		$this->sortableGroup = $group;

		return $this;
	}
}