<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\ChoiceInputTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\ChoiceControl;
use Nette\Utils\Html;

class BoolInput extends ChoiceControl
{
	use ChoiceInputTrait;
	use TInputExtend;

	/** @var array */
	protected $items = [];

	/** @var string */
	protected $textTrue = 'default.yes';

	/** @var string */
	protected $textFalse = 'default.no';

	/** @var Html */
	private $container;

	public function __construct($label = null, $defaultValue = 1)
	{
		parent::__construct($label, []);
		$this->setItems($this->getItems());
		$this->setDefaultValue($defaultValue);
		$this->control->type = 'radio';
		$this->container     = Html::el('div', ['class' => 'btn-group bool-switcher-control']);
		$this->setOption('type', 'radio');
	}

	public function setTextTrue($text)
	{
		$this->textTrue = $text;

		return $this;
	}

	public function setTextFalse($text)
	{
		$this->textFalse = $text;

		return $this;
	}

	public function getItems()
	{
		$this->items = [
			0 => $this->translate($this->textFalse),
			1 => $this->translate($this->textTrue),
		];

		return $this->items;
	}

	public function getControl()
	{
		// has to run
		parent::getControl();

		$items     = $this->getItems();
		$container = $this->container;

		foreach ($items as $value => $caption) {
			$disabledOption = $this->isValueDisabled($value);
			$isSelected     = $this->isValueSelected($value);

			$label = Html::el('label', ['class' => 'btn btn-' . ($isSelected ? '' : 'outline-') . ($value == 1 ? 'success' : 'danger')]);
			$input = Html::el('input', [
				'class'    => 'form-check-input',
				'type'     => 'radio',
				'value'    => $value,
				'name'     => $this->getHtmlName(),
				'checked'  => $isSelected,
				'disabled' => $disabledOption,
			]);
			$label->addHtml($input);
			$label->addText($caption);

			$container->addHtml($label);
		}

		return $container;
	}
}
