<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Utils\Html;

/**
 * Class SortableCheckboxList
 */
class SortableCheckboxList extends CheckboxListInput
{

	public function getControl()
	{
		parent::getControl();
		$fieldset = Html::el('div class=sortable-checkbox-list');

		$list = [];
		foreach ($this->value ?: [] as $k => $v) {
			if (isset($this->items[$v])) {
				$list[$v] = $this->items[$v];
			}
		}

		foreach ($list + $this->items as $value => $caption) {
			$line = CheckboxInput::makeCheckbox($this->getHtmlName(), $caption, $this->isValueSelected($value),
				$value, false, $this->isValueDisabled($value));

			$fieldset->addHtml(Html::el('div class=item data-active=' . ($this->isValueSelected($value) ? '1' : '0'))->addHtml('<div class="icon"><i class="fas fa-sort"></i></div>')->addHtml($line));
		}

		return $fieldset;
	}
}
