import flatpickr from "flatpickr";
import {Czech}   from "flatpickr/dist/l10n/cs.js";

const initDatePickers = () => {
	document.querySelectorAll('.datetimepicker, .datepicker').forEach(el => {
		const parentElement = el.parentElement;

		if (!el.closest('.flatpicker-wrap')) {
			let clearA = document.createElement('a');
			clearA.setAttribute('class', 'btn btn-xs btn-danger');
			clearA.setAttribute('href', 'javascript:;');
			clearA.setAttribute('data-clear', '');
			clearA.innerHTML = '<i class="fas fa-times"></i>';

			try {
				parentElement.classList.add('flatpicker-wrap');
				parentElement.insertBefore(clearA, parentElement.nextElementSibling);
				el.parentElement.appendChild(clearA);
			} catch (e) {
			}
		}

		el.addEventListener('click', e => {
			if (el.inited === true)
				return;
			let isDate = el.classList.contains('datepicker') || el.type === 'date';

			let options = {
				locale     : Czech,
				minDate    : el.dataset.min,
				maxDate    : el.dataset.max,
				time_24hr  : true,
				dateFormat : isDate ? 'd. m. Y' : 'd. m. Y - H:i',
				enableTime : !isDate,
				defaultDate: el.getAttribute('value'),
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			clearEl.addEventListener('click', e => {
				if (el.inited === true)
					el._flatpickr.clear();
				else
					el.value = '';
			});
		}
	})
}
const initTimePickers = () => {
	document.querySelectorAll('.timepicker').forEach(el => {
		el.addEventListener('click', e => {
			if (el.inited === true)
				return;

			let options = {
				locale     : Czech,
				minTime    : el.dataset.min,
				maxTime    : el.dataset.max,
				time_24hr  : true,
				dateFormat : 'H:i',
				enableTime : true,
				noCalendar : true,
				defaultDate: el.getAttribute('value'),
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			clearEl.addEventListener('click', e => {
				el._flatpickr.clear();
			});
		}
	})
}

const initSelectOne = () => {
	document.querySelectorAll('.nested-list').forEach(group => {
		let items = group.querySelectorAll('.nested-list__item');
		items.forEach(el => {
			let span = el.querySelector('.select-one');

			if (span) {
				span.addEventListener('click', e => {
					e.stopImmediatePropagation();

					group.querySelectorAll('.nested-list__item input:checked').forEach(input => {
						input.removeAttribute('checked');
						input.checked = false;
					});

					let input = span.nextElementSibling;

					input.checked = true;
					input.dispatchEvent(new Event('change'));

					return false;
				})
			}
		});
	});
}


initDatePickers();
initTimePickers();
initSelectOne();

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	initDatePickers();
	initTimePickers();
	initSelectOne();
});

global.naja.addEventListener('complete', e => {
	initDatePickers();
	initTimePickers();
	initSelectOne();
});
