import autoComplete from "@tarekraafat/autocomplete.js"

export class Autocomplete {
	constructor() {
		this.dataLoaded = [];
		this.lastXhr    = [];

		document.addEventListener('focusin', e => {
			let input = e.target;
			if (input.dataset.autocompleteUrl && input.autocompleteInited !== true) {
				input.autocompleteInited = true;

				const name     = input.dataset.autocompleteName;
				const url      = input.dataset.autocompleteUrl;
				const inputId  = input.id;
				const resultItemData =input.dataset.resultItemData;
				const targetId = input.dataset.autocompleteTarget;
				const target   = targetId ? document.getElementById(targetId) : null;
				let keys       = input.dataset.autocompleteKeys;

				if (keys)
					keys = keys.split(',');
				else
					keys = ['id', 'name'];

				input.parentElement.style.position = 'relative';

				new autoComplete({
					data       : {
						src  : async () => {
							if (this.dataLoaded[url])
								return this.dataLoaded[url];

							if (typeof this.lastXhr[url] !== 'undefined' && this.lastXhr[url].hasOwnProperty('abort'))
								this.lastXhr[url].abort();

							let source = await fetch(url, {
								method: 'GET',
							});

							let result = await source.json();

							if (result.data !== undefined) {
								result = result.data;
							}

							this.dataLoaded[url] = [];
							for (let a in result) {
								let row = result[a];

								if (typeof row === 'string' || row instanceof String) {
									row = {
										id  : a,
										name: row,
									};
								} else {
									if (row.id === undefined) {
										row.id = a;
									}
								}

								this.dataLoaded[url][a] = row;
							}

							return this.dataLoaded[url];
						},
						key  : keys,
						cache: true,
					},
					cache      : false,
					selector   : '#' + inputId,
					maxResults : 20,
					threshold  : 1,
					resultsList: {
						render     : true,
						destination: input,
						position   : "afterend",
						element    : "ul"
					},
					resultItem : {
						content: (data, source) => {
							if (global.document.autocompleteResultItem && typeof global.document.autocompleteResultItem[name] === "function") {
								global.document.autocompleteResultItem[name](data, source);
							} else if (resultItemData) {
								let output = [];
								resultItemData.split(',').forEach(itm => {
									output.push(data.value[itm]);
								});

								source.innerHTML = output.join(' | ');
							} else {
								source.innerHTML = data.value.id + ' | ' + data.value.name;
							}
						},
						element: "li"
					},
					onSelection: feedback => {
						input.value = feedback.selection.value.name;
						if (target)
							target.value = feedback.selection.value.id;

						let event = new CustomEvent('autocompleteOnSelection', {
							detail: {
								name     : name,
								selection: feedback.selection,
								inputId  : inputId,
								targetId : targetId,
							},
						});
						Object.defineProperty(event, 'target', {writable: false, value: input});

						document.dispatchEvent(event);
					}
				});
			}
		})
	}
}
