import {addEventForChild} from './utils/utilities';

document.addEventListener('DOMContentLoaded', () => {
	const darker = document.querySelector('.darker');
	const body   = document.querySelector('body');

	if (darker) {
		addEventForChild(body, 'click', '[data-modal]', el => {
			const modalTarget = el.dataset.modal;
			if (modalTarget) {
				document.querySelectorAll(modalTarget).forEach(el => el.classList.add('modal--active'));
			}
			darker.classList.add('darker--active');
		});

		darker.addEventListener('click', () => {
			document.querySelectorAll('.modal').forEach(el => {
				el.classList.remove('modal--active');
				darker.classList.remove('darker--active');
			});
		});

		addEventForChild(body, 'click', '.modal__close, [data-modal-close]', el => {
			document.documentElement.classList.remove('overflow-hidden');
			document.querySelectorAll('.modal').forEach(el => el.classList.remove('modal--active'));
			darker.classList.remove('darker--active');
		});
	}
});
