<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\Entities\Site;
use Core\Model\Helpers\BaseEntityService;

/**
 * Class Sites
 * @package Core\AdminModule\Model
 */
class Sites extends BaseEntityService
{
	protected $entityClass = Site::class;

	protected ?array $cAll = null;

	/**
	 * @param string $name
	 *
	 * @return Site|null
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function get(string $name): ?Site
	{
		return $this->getEr()->createQueryBuilder('s')
			->addSelect('st')
			->innerJoin('s.texts', 'st')
			->where('s.ident = :ident')
			->setParameter('ident', $name)
			->getQuery()->getOneOrNullResult();
	}

	/**
	 * @return Site[]
	 */
	public function getAll(): array
	{
		if ($this->cAll === null) {
			$this->cAll = $this->getEr()->createQueryBuilder('s')
				->addSelect('st')
				->innerJoin('s.texts', 'st')
				->getQuery()->getResult();
		}

		return $this->cAll;
	}

	public function getOptionsForSelect(): array
	{
		$arr = [];
		foreach ($this->getEr()->createQueryBuilder('s')->select('s.ident')
			         ->getQuery()->getScalarResult() as $row)
			$arr[$row['ident']] = $row['ident'];

		return $arr;
	}
}
