<?php declare(strict_types = 1);

namespace Core\Components;

use Core\Model\Event\EventDispatcher;
use Core\Model\Event\PartRenderEvent;
use Nette\Application\UI\Control;

class PartRenderControl extends Control
{
	protected EventDispatcher $eventDispatcher;

	public function __construct(EventDispatcher $eventDispatcher)
	{
		$this->eventDispatcher = $eventDispatcher;
	}

	public function render(string $type): void
	{
		$event = new PartRenderEvent($type, $this->getParent());
		$this->eventDispatcher->dispatch($event, 'partRender');

		$this->template->type = $type;
		$this->template->data = $event->getData();

		$this->template->render(__DIR__ . '/PartRenderControl.latte');
	}
}
