<?php declare(strict_types = 1);

namespace Core\Console\Database;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Core\Model\Entities\EntityManagerDecorator;
use MySQLDump;
use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class Backup extends AbstractCommand
{
	/** @var EntityManagerDecorator @inject */
	public $em;

	protected function configure()
	{
		$this->setName('database:backup')->setDescription('Backup application database');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$conn      = $this->em->getConnection();
		$today     = (new DateTime)->format('Y-m-d_H-i-s');
		$dir       = APP_DIR . '/../backup/' . (new DateTime())->format('Y');
		$extension = 'sql.gz';

		$output->writeln('DATABASE BACKUP');
		try {
			FileSystem::createDir($dir);
			$params = $conn->getParams();
			$dump = new MySQLDump(new \mysqli($params['host'], (string) $params['user'], (string) $params['password'], $conn->getDatabase()));

			$output->writeLn('<info>backup structure</info>');
			$dump->tables['*'] = MySQLDump::CREATE;
			try {
				$dump->save("$dir/{$today}_structure.$extension");
				$output->writeLn('<info>[OK] - structure is backed up</info>');
			} catch (\Exception $e) {
				$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
			}

			$output->writeLn('<info>backup data</info>');
			$dump->tables['*'] = MySQLDump::DATA;
			try {
				$dump->save("$dir/{$today}_data.$extension");
				$output->writeLn('<info>[OK] - data is backed up</info>');
			} catch (\Exception $e) {
				$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
			}
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
