<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Core\Model\Event\RobotsTxtEvent;
use Core\Model\Sites;

class RobotsPresenter extends BasePresenter
{
	protected Sites $sites;

	public function __construct(Sites $sites)
	{
		$this->sites = $sites;
	}

	public function actionDefault()
	{
		$content = "User-agent: *\n" .
			"Disallow: /admin\n" .
			"Disallow: /assets/admin\n" .
			"Disallow: /assets/admin2\n";

		$content .= "\n";

		$currentSite   = $this->sites->getCurrentSite();
		$currentDomain = $currentSite->getCurrentDomain();

		foreach (glob(WWW_DIR . "/sitemap-{$currentSite->getIdent()}-*-{$currentDomain->getLang()}.xml") as $file) {
			$content .= "Sitemap: " . str_replace(WWW_DIR . '/', $this->getHttpRequest()->getUrl()->baseUrl, $file) . "\n";
		}

		$this->eventDispatcher->dispatch(new RobotsTxtEvent($content), 'core.generateRobotsTxt');

		header("Content-Type: text/plain");
		echo $content;
		$this->terminate();
	}
}
