<?php declare(strict_types = 1);

namespace Core\Model\Dao;

class SiteDomain
{
	public Site $site;

	/** @var string */
	public $domain;

	/** @var string */
	public $siteName;

	/** @var string */
	public $siteNameSeparator;

	/** @var string */
	protected $lang;

	/** @var int */
	public $isDefault = 0;

	public bool $isActive = true;

	public function __construct(Site $site, string $domain, string $lang, int $isDefault = 0)
	{
		$this->site      = $site;
		$this->domain    = $domain;
		$this->lang      = $lang;
		$this->isDefault = $isDefault;
		$site->addDomain($this, $isDefault);
	}

	public function getDomain(): string { return $this->domain; }

	public function setLang(string $lang) { $this->lang = $lang; }

	public function getLang(): string { return $this->lang; }

	public function getDefaultCountry(): string
	{
		if ($this->lang === 'cs')
			return 'CZ';
		else if ($this->lang === 'sk')
			return 'SK';

		return $this->lang;
	}
}
