<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="core__site_text", indexes={@ORM\Index(name="search_idx", columns={"is_active", "is_default"})})
 * @ORM\Entity
 */
class SiteText
{

	/**
	 * @var Site
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Site", inversedBy="texts")
	 * @ORM\JoinColumn(name="site", referencedColumnName="ident", onDelete="CASCADE", nullable=false)
	 */
	protected $site;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=255, nullable=false, options={"default":"cs"})
	 */
	protected $lang;

	/**
	 * @var string
	 * @ORM\Column(name="domain", type="string", length=255, nullable=false)
	 */
	public $domain;

	/**
	 * @var string
	 * @ORM\Column(name="site_name", type="string", length=255, nullable=true)
	 */
	public $siteName;

	/**
	 * @ORM\Column(name="is_default", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public int $isDefault = 0;

	/**
	 * @ORM\Column(name="is_active", type="smallint", length=1, nullable=false, options={"default": 1})
	 */
	public int $isActive = 1;

	public function __construct(Site $site, string $domain, string $lang = 'cs')
	{
		$this->site      = $site;
		$this->domain    = $domain;
		$this->lang      = $lang;
		$this->isDefault = 0;
	}

	public function getSite(): Site { return $this->site; }

	public function getLang(): string { return $this->lang; }
}
