<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Nette\Utils\Html;
use Symfony\Contracts\EventDispatcher\Event;

class PartRenderEvent extends Event
{
	protected string $key;

	protected $control;

	protected array $data = [];

	public function __construct(string $key, $control)
	{
		$this->key     = $key;
		$this->control = $control;
	}

	public function getKey(): string { return $this->key; }

	public function getControl() { return $this->control; }

	public function getData() { return $this->data; }

	protected function addData(string $type, $value)
	{
		$this->data[] = [
			'type' => $type,
			'data' => $value,
		];
	}

	public function addRenderHtml(Html $html) { $this->addData('html', $html); }

	public function addRenderFile(string $file) { $this->addData('file', $file); }

	public function addRenderTemplate(string $file, array $params, array $data = [])
	{
		$this->addData('template', [
			'file'   => $file,
			'params' => $params,
			'data'   => $data,
		]);
	}
}
