<?php declare(strict_types = 1);

namespace Core\Model;

use Core\Model\Entities\FileRequest;
use Core\Model\Helpers\BaseEntityService;

/**
 * @method FileRequest|object|null getReference($id)
 * @method FileRequest get($id)
 */
class FileRequests extends BaseEntityService
{
	/** @var string */
	protected $entityClass = FileRequest::class;

	public function add(string $data): FileRequest
	{
		$fileRequest = new FileRequest($data);
		$this->em->persist($fileRequest);
		$this->em->flush($fileRequest);

		return $fileRequest;
	}
}
