<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Doctrine\ORM\EntityRepository;
use Core\Model\Entities\EntityManagerDecorator;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;

abstract class BaseEntityService extends BaseService
{
	/** @var EntityManagerDecorator @inject */
	public $em;

	/** @var EntityRepository */
	protected $er;

	/** @var string */
	protected $entityClass;

	/**
	 * @return EntityRepository|\Kdyby\Doctrine\EntityRepository
	 */
	public function getEr()
	{
		if ($this->er === null)
			$this->er = $this->em->getRepository($this->entityClass);

		return $this->er;
	}

	public function getReference($id) { return $this->getEr()->getReference($id); }

	/**
	 * Vraci instanci entity podle primarniho klice s oznacením id
	 *
	 * @param $id
	 *
	 * @return array|mixed|null|object
	 */
	public function get($id)
	{
		return is_array($id) ? $this->getEr()->findBy(['id' => $id]) : $this->getEr()->find($id);
	}

	public function getAll() { return $this->getEr()->findAll(); }

	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
