<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

class DatabaseConfig
{
	public static array $config = [];

	public static function getUser(): string
	{
		if (isset(self::$config['cron']['user']) && self::isCron())
			return (string) self::$config['cron']['user'];

		return (string) self::$config['default']['user'];
	}

	public static function getPassword(): string
	{
		if (isset(self::$config['cron']['password']) && self::isCron())
			return (string) self::$config['cron']['password'];

		return (string) self::$config['default']['password'];
	}

	public static function getDbName(): string
	{
		return (string) self::$config['default']['dbname'];
	}

	public static function getDsn(): string
	{
		$result = 'mysql:dbname=' . self::getDbName() . ';';

		if (strtolower((string) PHP_OS) === 'linux')
			$result .= 'host=/var/lib/mysql/mysql.sock';
		else
			$result .= 'host=' . (self::$config['default']['host'] ?: '127.0.0.1');

		return $result;
	}

	protected static function isCron(): bool
	{
		return php_sapi_name() === 'cli' || strpos((string)$_SERVER['REQUEST_URI'], '/cron') === 0;
	}
}
