<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Doctrine\Common\Collections\Collection;
use Nette\ComponentModel\IContainer;
use Nette\Forms\Controls\SelectBox;

class FormHelper
{
	public static function fillContainerByEntity(IContainer &$container, $entity): void
	{
		foreach ($container->getControls() as $input) {
			$name = $input->getName();

			if (!isset($entity->$name) || $entity->$name instanceof Collection)
				continue;

			if ($input instanceof SelectBox) {
				if (array_key_exists($entity->$name, $input->getItems()))
					$input->setDefaultValue($entity->$name);
			} else {
				$input->setDefaultValue($entity->$name);
			}
		}
	}

	public static function fillEntityByValues(&$entity, $values): void
	{
		foreach (get_object_vars($entity) as $k => $v) {
			if (isset($values[$k]))
				$entity->$k = $values[$k];
		}
	}

	public static function getTemplateFiles(string $subDirectory): array
	{
		$arr = [];

		$subDirArr = explode('/', $subDirectory);

		foreach (glob(TEMPLATES_DIR . DS . 'Front' . DS . '*', GLOB_ONLYDIR) as $dir) {
			$dirName = basename($dir);

			foreach (glob($dir . DS . $subDirectory . DS . '*.latte') as $file) {
				$fileName = pathinfo($file, PATHINFO_FILENAME);

				$arr[$dirName][$dirName . '|' . $fileName] = 'admin.' . implode('.', array_map(fn($v) => lcfirst($v), $subDirArr)) . '.' . $fileName;
			}
		}

		if (count($arr) == 1)
			$arr = array_values($arr)[0];

		return $arr;
	}
}
