<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

use Core\Model\Parameters;
use Nette\Mail\Mailer;
use Nette\Mail\SmtpMailer;

class MailBuilderFactory
{
	/** @var Mailer|SmtpMailer */
	protected $sender;

	protected TemplateFactory $templateFactory;

	public ?string $siteIdent = null;

	public function __construct(Mailer $sender, TemplateFactory $templateFactory)
	{
		if (Parameters::load('mailSender.enableSmtp', false) && Parameters::load('mailSender.smtp', null))
			$this->sender = new SmtpMailer(Parameters::load('mailSender.smtp'));
		else
			$this->sender = $sender;

		$this->templateFactory = $templateFactory;
	}

	/**
	 * @return MailBuilder
	 */
	public function create()
	{
		$mail = new MailBuilder($this->sender);

		if ($this->siteIdent)
			$mail->setTemplate($this->templateFactory->create($this->siteIdent));

		return $mail;
	}
}
