<?php declare(strict_types = 1);

namespace Core\Model\Navigation;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\AdminModule\Model\Navigations;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Search extends BaseNavigation implements INavigationItem
{
	/** @var string */
	protected $langBase = 'default.navigationBuilderCore';

	/** @var string */
	protected $title = 'search';

	/** @var string */
	protected $presenter = 'Core:Front:Default';

	/** @var string */
	protected $action = 'search';

	/**
	 * @param BaseForm $baseForm
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	/**
	 * @param Navigation $navigation
	 * @param array      $urlParams
	 *
	 * @return array
	 */
	public function routerIn($navigation, $urlParams = []): array
	{
		$return = [
			'presenter' => $this->presenter,
			'action'    => $this->action,
		];

		$parts = explode('/', $urlParams['path']);

		if (isset($parts[1]))
			$return['q'] = $parts[1];
		else if (isset($urlParams['q']))
			$return['q'] = $urlParams['q'];

		return $return;
	}

	/**
	 * @param Navigation $navigation
	 * @param array      $urlParams
	 *
	 * @return string
	 */
	public function routerOut($navigation, &$urlParams): string
	{
		$q = $urlParams['q'] ?? null;
		unset($urlParams['q']);

		$url = ($navigation->isHomepage ? '' : '/' . $navigation->alias) . ($q ? '/' . $q : '');

		return $url;
	}
}
