<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Providers;

use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\UI\Form\BaseContainer;

interface ITemplateTextType
{
	/**
	 * @return string
	 */
	public function getType();

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 * @param ITemplate[]   $texts
	 */
	public function loadContainer($formContainer, $params = [], $texts = []);

	/**
	 * @param string $title
	 */
	public function setTitle($title);

	/**
	 * @return string
	 */
	public function getTitle();

	/**
	 * @param string $name
	 */
	public function setName($name);

	/**
	 * @return string
	 */
	public function getName();

	/**
	 * @param mixed $default
	 */
	public function setDefault($default);

	/**
	 * @return mixed
	 */
	public function getDefault();

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function render($params);
}