<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\Lang\ILang;
use Core\Model\Lang\Langs;

/**
 * Class LangsSelectInput
 * @package Core\Model\UI\Form\Controls
 */
class LangsSelectInput extends SelectInput
{
	/** @var Langs */
	protected $langsService;

	/** @var bool */
	protected $allowAllLang = true;

	public function __construct($label = null, Langs $langs)
	{
		$this->langsService = $langs;
		$items              = ['' => 'default.all'];

		foreach ($langs->getLangs() as $lang) {
			if ($lang instanceof ILang)
				$items[$lang->getTag()] = $lang->getTitle();
		}

		parent::__construct($label, $items);

		$this->setDefaultValue($langs->getLang());
	}

	/**
	 * @param bool $allow
	 *
	 * @return $this
	 */
	public function allowAllLang($allow = true)
	{
		$this->allowAllLang = $allow;

		return $this;
	}

	/**
	 * @param array $items
	 *
	 * @return $this|SelectInput
	 */
	public function setItems(array $items, $useKeys = true)
	{
		if ($items) {
			parent::setItems($items);
		} else {
			$items = $this->allowAllLang ? ['' => 'default.all'] : [];
			$langs = $this->langsService;

			foreach ($langs->getLangs() as $lang) {
				if ($lang instanceof ILang)
					$items[$lang->getTag()] = $lang->getTitle();
			}

			parent::setItems($items);
			$this->setDefaultValue($langs->getLang());
		}

		return $this;
	}

	/*******************************************************************************************************************
	 * ======================== REGISTER
	 */

	/**
	 * @param \Nette\DI\Container $systemContainer
	 */
	public static function register(\Nette\DI\Container $systemContainer)
	{
		$class = __CLASS__;
		\Nette\Forms\Container::extensionMethod('addLangsSelect', function(
			\Nette\Forms\Container $container, $name, $caption
		) use ($class, $systemContainer) {
			/** @var LangsSelectInput $comp */
			$comp = new $class($caption, $systemContainer->getService('langs'));

			$container->addComponent($comp, $name);

			return $comp;
		});
	}
}
