const path                 = require('path');
const config               = require('./admin.config');
const LiveReloadPlugin     = require('webpack-livereload-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const CssMinimizerPlugin   = require('css-minimizer-webpack-plugin');
const VueLoaderPlugin      = require('vue-loader/lib/plugin');
const webpack              = require("webpack");
const CopyPlugin           = require('copy-webpack-plugin');
const TerserJSPlugin       = require('terser-webpack-plugin');

const devMode    = process.argv[process.argv.indexOf('--mode') + 1] === 'development';
const CACHE_PATH = path.join(__dirname, '../../../www/assets/cache');

module.exports = {
	// Odkaz na node_moduly v core
	stats  : 'minimal',
	mode   : devMode ? "development" : "production",
	resolve: {
		alias     : config.aliases,
		extensions: ['.js', '.css', '.scss', '.vue', '.tsx', '.ts']
	},
	// Definice vstupnich souboru
	entry       : config.entry,
	devtool     : 'cheap-module-source-map',
	cache       : {
		type          : 'filesystem',
		cacheDirectory: path.resolve(CACHE_PATH, 'cache'),
	},
	optimization: {
		minimize   : true,
		minimizer  : [
			new TerserJSPlugin({
				parallel       : true,
				extractComments: false,
			}),
			new CssMinimizerPlugin({
				minimizerOptions: {
					preset: [
						'default',
						{
							discardComments: {removeAll: true},
						},
					],
				},
			}),
		],
		splitChunks: {
			cacheGroups: {
				polyfills: {
					test   : /[\\/]node_modules[\\/](@babel|core-js|regenerator-runtime)[\\/]/,
					name   : 'polyfills',
					chunks : 'initial',
					minSize: 0,
				},
				baseLibs : {
					test   : /[\\/]node_modules[\\/](naja|es6-slide-up-down|utilities)[\\/]/,
					name   : 'baseLibs',
					chunks : 'all',
					minSize: 0,
				},
			},
		}
	},
	//Definice výstupních cest
	output : {
		path    : path.join(__dirname, '../../../www/assets/admin'),
		filename: 'js/[name].js'
	},
	plugins: [
		new MiniCssExtractPlugin({filename: '_css/[name].css'}),
		new LiveReloadPlugin(),
		new VueLoaderPlugin(),
		new webpack.ProvidePlugin({
			$              : 'jquery',
			jQuery         : 'jquery',
			'window.jquery': 'jquery'
		}),
		new CopyPlugin({
			patterns: [
				{
					from   : 'vendor/pshkcms/core/assets/default',
					to     : 'default',
					context: ''
				},
				{
					from   : 'vendor/pshkcms/core/assets/el-finder',
					to     : 'el-finder',
					context: ''
				},
				{
					from   : 'vendor/pshkcms/core/assets/img',
					to     : 'img',
					context: ''
				},
				{
					from   : 'vendor/pshkcms/core/assets/shared',
					to     : 'shared',
					context: ''
				}
			]
		}),
	],
	module : {
		rules: [
			{
				test   : /\.m?js$/,
				exclude: /(node_modules|bower_components)/,
				use    : {
					loader : 'babel-loader',
					options: {
						cacheDirectory: path.join(__dirname, '../../../www/assets/cache'),
						presets       : [
							[
								"@babel/preset-env",
								{
									corejs       : '3.0.0',
									"useBuiltIns": "usage"
								}
							]
						],
					}
				}
			},
			{
				test  : /\.vue$/,
				loader: 'vue-loader'
			},
			{
				test: /\.(sa|sc|c)ss$/,
				use : [
					MiniCssExtractPlugin.loader,
					'css-loader?-url',
					{
						loader : 'postcss-loader',
						options: {
							postcssOptions: {
								plugins: ['autoprefixer']
							}
						}
					},
					'sass-loader',
				],
			},
			{
				test   : /\.tsx?$/,
				use    : 'ts-loader',
				exclude: /(node_modules|bower_components|elfinder)/,
			},
		]
	}
};
