// document.ckEditorDefaultConfig =

CKEDITOR.editorConfig = function (config) {
	config.language = 'cs';
	config.allowedContent = true;
	config.contentsCss = ['/assets/admin/default/ckeditor/contents.css?v=5']; //i google fonty
	config.enterMode = CKEDITOR.ENTER_P;
	config.shiftEnterMode = CKEDITOR.ENTER_BR;
	config.autoParagraph = false;
	// config.fillEmptyBlocks = false;
	config.format_tags = 'p;h1;h2;h3;h4;h5;h6;pre;address;div;span';
	config.format_span = {name: 'Span', element: 'span'};
	config.entities_latin = false;
	config.line_height = "1em;1.2em;1.4em;1.6em;1.8em;2.0em;2.3em;2.6em;2.9em;3.3em";
	config.toolbar_Basic2 = [
		['Source', '-', 'Bold', 'Italic', 'Underline', '-', 'Cut', 'Copy', 'Paste', 'Undo', 'Redo', '-', 'Link', 'Unlink', 'FileManager'],
	];
	config.toolbar_Text = [
		{
			name: 'clipboard',
			items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo']
		},
		{name: 'links', items: ['Link', 'Unlink']},
		{name: 'styles', items: ['Styles', 'Format']},
	];
	config.toolbar_Basic = [
		{name: 'clipboard', items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo']},
		{name: 'editing', items: ['Scayt']},
		{name: 'links', items: ['Link', 'Unlink', 'Anchor']},
		{name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'SpecialChar']},
		{name: 'styles', items: ['Styles', 'Format']},
		{name: 'tools', items: ['Maximize']},
		{name: 'document', items: ['Source']},
		'/',
		{
			name: 'basicstyles',
			items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'RemoveFormat', '-', 'TextColor', 'BGColor', 'lineheight']
		},
		{name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote']},
		{name: 'justify', items: ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']},
		{name: 'font', items: ['Font', 'FontSize']},
	];
	config.toolbar_Blog = [
		{name: 'clipboard', items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo']},
		{name: 'editing', items: ['Scayt']},
		{name: 'links', items: ['Link', 'Unlink', 'Anchor']},
		{name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'SpecialChar']},
		{name: 'styles', items: ['Styles', 'Format']},
		{name: 'tools', items: ['Maximize']},
		{name: 'document', items: ['Source']},
		'/',
		{
			name: 'basicstyles',
			items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'RemoveFormat', '-', 'TextColor', 'BGColor', 'lineheight']
		},
		{name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote']},
		{name: 'justify', items: ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']},
		{name: 'font', items: ['Font', 'FontSize']},
	];
	config.toolbarGroups = [
		{name: 'clipboard', groups: ['clipboard', 'undo']},
		{name: 'editing', groups: ['find', 'selection', 'spellchecker', 'editing']},
		{name: 'links', groups: ['links']},
		{name: 'insert', groups: ['insert']},
		{name: 'forms', groups: ['forms']},
		{name: 'tools', groups: ['tools']},
		{name: 'document', groups: ['mode', 'document', 'doctools']},
		{name: 'others', groups: ['others']},
		'/',
		{name: 'basicstyles', groups: ['basicstyles', 'cleanup']},
		{name: 'paragraph', groups: ['list', 'indent', 'blocks', 'align', 'bidi', 'paragraph']},
		{name: 'styles', groups: ['styles']},
		{name: 'colors', groups: ['colors']},
		{name: 'about', groups: ['about']}
	];

	config.extraPlugins = 'panelbutton,button,floatpanel,panel,justify,colorbutton,font,filemanager,lineheight,readmore';
	// config.removeButtons = 'Templates,Replace,Find,SelectAll,SpellChecker,CreateDiv,Link,Anchor,HorizontalRule,SpecialChar,Iframe,Font';

	document.ckEditorConfig = config;
	$(document).trigger('ckEditorEditConfig', {
		'config': config,
	});
	// Object.assign(config, document.ckEditorAppConfig);
};
// CKEDITOR.dtd.customtag = {em: 1};        // List of tag names it can contain.
// CKEDITOR.dtd.$block.customtag = 1;        // Choose $block or $inline.
// CKEDITOR.dtd.body.customtag = 1;          // Body may contain customtag.
// CKEDITOR.dtd.sc = 1;

CKEDITOR.on('instanceReady', function (ev) {
	ev.editor.on('paste', function (evt) {
		evt.data['html'] = '<!--class="Mso"-->' + evt.data['html'];
	}, null, null, 9);
});

// TODO do jiného js souboru
CKEDITOR.stylesSet.add('titles', [
	{name: 'beige', element: 'span', styles: {color: '#fff1d7'}},
	{name: 'dark-purple', element: 'span', styles: {color: '#413543'}},
	{name: 'yellow', element: 'span', styles: {color: 'yellow'}},
	{name: 's', element: 'span', styles: {color: '#413543'}},
]);
