<?php declare(strict_types = 1);

namespace Core\Components\Navigation;

use Kdyby\Doctrine\Entities\MagicAccessors;
use Navigations\Model\Entities\Navigation;

class DaoNavigationItem
{
	//	use SmartObject;

	public $id;
	public $title;
	public $link;
	public $ico;
	public $icoClass;
	public $image;
	public $isParent        = false;
	public $class           = '';
	public $isCurrent;
	public $childs          = [];
	public $parent;
	public $order           = 100;
	public $security        = null;
	public $openIn          = null;
	public $componentType;
	public $componentParams = [];
	public $confirm;

	public function __construct($arr, $parent = null)
	{
		$parameters = get_class_vars(self::class);

		if (is_object($arr)) {
			$tmp = (array) $arr;
			if ($arr instanceof Navigation) {
				foreach ($arr->getParams() as $k => $v) {
					$tmp[$k] = $v;
				}
			}

			$arr = $tmp;
		}

		foreach ($arr as $key => $value) {
			if ($key === 'ico') {
				$expl  = explode(' ', $value);
				$value = count($expl) === 1 ? 'fa fa-' . $value : $value;
			}

			if (array_key_exists($key, $parameters))
				$this->$key = $value;
			elseif ($key === 'items') {
				$this->isParent = true;
				foreach ($value as $deepK => $deepV)
					$this->childs[$deepK] = new DaoNavigationItem($deepV, $this);
			}
		}

		$this->parent = &$parent;
	}

	public function set($key, $value)
	{
		$this->$key = $value;
	}

	/**
	 * @return bool
	 */
	public function isChildrenCurrent()
	{
		foreach ($this->childs as $item) {
			if ($item->isCurrent)
				return true;
		}

		return false;
	}

	/**
	 * @param DaoNavigationItem $dao
	 *
	 * @return $this
	 */
	public function addChild(DaoNavigationItem $dao)
	{
		$this->childs[] = $dao;

		return $this;
	}
}
