<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use Core\Model\UI\Form\BaseContainer;
use Nette\Utils\ArrayHash;

class SeoContainer
{
	/** @var SiteMap */
	protected $siteMapService;

	public function __construct(SiteMap $siteMap)
	{
		$this->siteMapService = $siteMap;
	}

	public function getContainer($multilang = false)
	{
		$container = new BaseContainer();

		$container->addText('title', 'default.seoContainer.title')->setDescription('default.seoContainer.titleDesc');
		$container->addTextArea('description', 'default.seoContainer.description')->setDescription('default.seoContainer.titleDesc');
		$container->addSelect('robots', 'default.seoContainer.robots', [
			'index, follow'     => 'index, follow',
			'noindex, follow'   => 'noindex, follow',
			'noindex, nofollow' => 'noindex, nofollow',
		]);
		$container->addText('canonical', 'default.seoContainer.canonical')->setPlaceholder('self');
		$container->addBool('addToSiteMap', 'default.seoContainer.addToSiteMap')->setDefaultValue(1);
		$container->addSelect('siteMapChangeFreq', 'default.seoContainer.siteMapChangeFreq', $this->siteMapService->getAllChangeFreq())
			->setDefaultValue(SiteMap::CHANGE_FREQ_MONTHLY);
		$container->addText('siteMapPriority', 'default.seoContainer.siteMapPriority')->setDefaultValue('0.5');

		if ($multilang) {
			foreach (['title', 'description', 'robots', 'canonical', 'addToSiteMap', 'siteMapChangeFreq',
				         'siteMapPriority'] as $k) {
				$container[$k]->setIsMultilanguage();
			}
		}

		return $container;
	}

	/**
	 * @param array|ArrayHash $values
	 * @param bool            $multilang
	 *
	 * @return array
	 */
	public function getFormData($values, $multilang = false): array
	{
		if ($multilang) {
			$return = [];

			foreach ((array) $values as $key => $value) {
				foreach ($value as $lang => $v) {
					$return[$lang][$key] = $v;
				}
			}

			return $return;
		}

		return (array) $values;
	}

	/**
	 * @param BaseContainer $container
	 * @param array         $values
	 */
	public function setDefaults(&$container, $values)
	{
		foreach ($container->getControls() as $c) {
			if (isset($values[$c->getName()]))
				$c->setDefaultValue($values[$c->getName()]);
		}
	}
}
