<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Core\Components\Header\Title;
use Core\Components\Navigation\INavigationFactory;
use Core\FrontModule\Components\IContactFormFactory;
use Core\FrontModule\Components\StructureData\IDataSchemaFactory;
use Core\FrontModule\Model\SeoParser;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Navigations;
use Tracy\Debugger;

/**
 * Class BasePresenter
 * @package Core\FrontModule\Presenters
 */
abstract class BasePresenter extends CustomBasePresenter
{
	/** @var Navigations @inject */
	public $navigationsService;

	/** @var SeoParser @inject */
	public $seoParserService;

	/** @var Navigation */
	private $activeNavigation;

	/** @var string */
	public $baseUrl;

	/** @var array */
	public $seoDataFromEntity = [];

	protected $skipSetInitial = false;

	protected function startup()
	{
		parent::startup();

		if (!$this->skipSetInitial) {
			$this->activeNavigation     = $activeNavigation = $this->request->getParameter('activeNavigation');
			$this->baseUrl              = $this->getHttpRequest()->getUrl()->getBaseUrl();
			$this->template->breadcrumb = $this->navigationsService->getPath($activeNavigation);

			$this->template->_imagePipe       = $this->imagePipe;
			$this->template->activeNavigation = $this->activeNavigation ?: null;
			$this->template->lang             = $this->activeNavigation && $this->activeNavigation->getLangId()
				? $this->activeNavigation->getLangId()
				: $this->translator->getLocale();
			$this->template->homepage         = $this->navigationsService->getHomepage();
			$this->template->pageClass        = ($activeNavigation ? $activeNavigation->getParam('pageClass') : '') . ' lang-' . $this->template->lang['shortTag'];
			$this->template->pageBackground   = $activeNavigation && $activeNavigation->background ? $activeNavigation->background : null;
		}


		//		$this['meta']->setMeta('robots', $this->optionsService->get('metaRobots'))
		//			->setMeta('description', $this->optionsService->get('site_description_short'))
		//			->setMeta('og:description', $this->optionsService->get('site_description'), 'property')
		//			->setMeta('og:image', $this->baseUrl . ltrim($this->optionsService->get('site_logo_main'), '/'), 'property')
		//			->setMeta('og:image:alt', $this->optionsService->get('site_description_short'), 'property');

		//		$schema = Schema::webSite()
		//			->name($this->optionsService->get('site_title'))
		//			->url($this->link('//this'));
		//		$this['dataSchemaControl']->addSchema($schema);
	}

	public function beforeRender()
	{
		parent::beforeRender();

		$this->activeNavigation = $activeNavigation = $this->request->getParameter('activeNavigation');
		if ($activeNavigation) {
			if ($this->seoDataFromEntity)
				$activeNavigation->setSeo(array_merge((array) $activeNavigation->getSeo(), (array) $this->seoDataFromEntity));

			if (!$this['title']->getTitle()) {
				if ($activeNavigation->isHomepage && !$activeNavigation->getSeo('title'))
					$this->setTitle('$siteName', true);
				else if ($activeNavigation->getSeo('title'))
					$this->setTitle($activeNavigation->getSeo('title'), true);
				else
					$this->setTitle($activeNavigation->title, false);
			}

			$metaSeo = ['description', 'robots'];
			foreach ($metaSeo as $v) {
				if (!$activeNavigation->getSeo($v))
					continue;

				$this['meta']->setMeta($v, $activeNavigation->getSeo($v));
			}
		}

		if ($this->systemConfig->get('testMode') === true)
			$this['meta']->setMeta('robots', 'noindex, nofollow');
	}

	public function getActiveNavigation()
	{
		return $this->activeNavigation;
	}

	/*******************************************************************************************************************
	 * =============================== Handle
	 */

	public function handleLogout()
	{
		$this->getUser()->logout(true);
		$this->redirectUrl('/');
	}

	/*******************************************************************************************************************
	 * =============================== Components
	 */

	protected function createComponentContactForm(IContactFormFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentNavigation(INavigationFactory $factory)
	{
		$control = $factory->create();
		$control->setData($this->navigationsService->getPublishedToDaoNavigationItem());
		return $control;
	}

	protected function createComponentDataSchemaControl(IDataSchemaFactory $factory)
	{
		return $factory->create();
	}

	/*******************************************************************************************************************
	 * =============================== GET / SET
	 */

	/**
	 * @param string $title
	 * @param bool   $includeSiteName
	 */
	public function setTitle($title, $includeSiteName = false)
	{
		$this['title']->setTitle($title, $includeSiteName);
	}
}
