<?php declare(strict_types = 1);

namespace Core\Model\Lang;

/**
 * Class Lang
 * @package Core\Model\Lang
 */
class Lang implements ILang
{
	/** @var string */
	protected $title;

	/** @var string */
	protected $tag;

	/** @var string */
	protected $fullTag;

	/**
	 * Lang constructor.
	 * @param $title
	 * @param $tag
	 * @param $fullTag
	 */
	public function __construct($title, $tag, $fullTag)
	{
		$this->title = $title;
		$this->tag = $tag;
		$this->fullTag = $fullTag;
	}

	/**
	 * @return string
	 */
	public function getTitle()
	{
		return $this->title;
	}

	/**
	 * @return string
	 */
	public function getTag()
	{
		return $this->tag;
	}

	/**
	 * @return string
	 */
	public function getFullTag()
	{
		return $this->fullTag;
	}
}