<?php declare(strict_types = 1);

namespace Core\Model\MathParser\Operator;

use Core\Model\MathParser\Stack;

class Subtraction extends Operator
{
	protected $precidence = 4;

	public function operate(Stack $stack)
	{
		$left  = $stack->pop()->operate($stack);
		$right = $stack->pop();
		$right = ($right ? $right->operate($stack) : 0);
		return $right - $left;
	}
}