<?php declare(strict_types = 1);

namespace Core\Model\Navigation;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\AdminModule\Model\Navigations;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Alias extends BaseNavigation implements INavigationItem
{
	protected $title = 'alias';

	/** @var Navigations */
	protected $navigationsService;

	public function __construct(Navigations $navigations)
	{
		$this->navigationsService = $navigations;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		$navs = [];
		foreach ($this->navigationsService->getEr()->createQueryBuilder('n')->select('n.id, n.title, n.lvl')
			         ->andWhere('n.componentType != :cp')->setParameter('cp', 'navigation.alias')
			         ->andWhere('n.lvl > 0')
			         ->orderBy('n.root')->addOrderBy('n.lft')
			         ->getQuery()->getArrayResult() as $v) {
			$title = ' ' . $v['title'];
			for ($i = 1; $i < $v['lvl']; $i++)
				$title = '---' . $title;
			$navs[$v['id']] = trim($title);
		}

		$container->addSelect('navigation', 'default.navigationForm.navigation', $navs)->setRequired();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		return null;
	}

	public function routerOut($navigation, &$urlParams)
	{
		return null;
	}
}
