<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\Lang\DefaultLang;

/**
 * Class RouteHelper
 * @package Core\Model\Router
 */
class RouteHelper
{
	/** @var DefaultLang */
	protected $defaultLang;

	public function __construct(DefaultLang $defaultLang)
	{
		$this->defaultLang = $defaultLang;
	}

	public function createRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale) {
			$locale = $this->defaultLang->default;
		}

		return new Route($mask, $metadata, $flags, $locale);
	}

	public function createAdminRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale) {
			$locale = $this->defaultLang->default;
		}

		return new RouteAdmin($mask, $metadata, $flags, $locale);
	}
}
