<?php

namespace Core\Model\TemplateReader;

use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\UI\BaseControl;
use Nette\Http\Request;

/**
 * TODO Předělat celé do komponenty formuláře.
 *
 * Class TemplateReaderControl
 * @package Core\Model\TemplateReader
 */
abstract class TemplateReaderControl extends BaseControl implements ITemplateReaderControl
{
	/** @var ITemplate */
	protected $entity;

	/** @var Request */
	protected $httpRequest;

	/** @var TemplateReader */
	protected $templateReader;

	/** @var string @persistent */
	public $selectedTemplate;

	protected function attached($presenter)
	{
		parent::attached($presenter);

		$httpTemplate = null;
		if ($this->httpRequest->getPost('template'))
			$httpTemplate = $this->httpRequest->getPost('template');
		else if ($this->selectedTemplate)
			$httpTemplate = $this->selectedTemplate;

		if (!$this->entity && $httpTemplate) {
			$this->templateReader->loadTemplateComponents($this['form']['component'], $httpTemplate);
		}
	}

	public function setHttpRequest(Request $request) { $this->httpRequest = $request; }

	public function setTemplateReader(TemplateReader $templateReader) { $this->templateReader = $templateReader; }

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleLoadInputs($file)
	{
		$presenter = $this->getPresenter();

		try {
			$inputs = [];

			if (isset($this['form']['component'])) {
				foreach ($this['form']['component']->getComponents() as $v) {
					$this['form']['component']->removeComponent($this['form']['component'][$v->getName()]);
				}
			}

			$this->templateReader->loadTemplateComponents($this['form']['component'], $file);
			if ($this->entity) {
				$this->templateReader->setDefaults($this['form']['component'], $this->entity, $file);
			}

			$presenter->payload->inputs = $inputs;
			$presenter->flashMessageSuccess('default.loaded');
		} catch (\Exception $e) {
			$presenter->flashMessageDanger('default.error');
		}

		$this->selectedTemplate = $file;
		$this->redrawControl('component');
		$presenter->redrawControl('flashes');
	}
}