<?php declare(strict_types = 1);

namespace Core\Model\Templating;

use Contributte\Application\LinkGenerator;
use Core\Model\Images\ImagePipe;
use Core\Model\Settings;
use Nette;
use Nette\Application\UI;
use Nette\Bridges\ApplicationLatte\ILatteFactory;
use Nette\Caching\IStorage;
use Nette\Http\IRequest;
use Nette\Security\User;
use Nette\Utils\Html;

final class TemplateFactory extends Nette\Bridges\ApplicationLatte\TemplateFactory
{
	/** @var array */
	protected $support;

	/** @var string */
	protected $siteName;

	/** @var ImagePipe */
	protected $imagePipe;

	/** @var LinkGenerator */
	protected $linkGenerator;

	/** @var array */
	protected $webSettings = [];

	public function __construct($support, $siteName, ILatteFactory $latteFactory, IRequest $httpRequest = null, User $user = null, IStorage $cacheStorage = null, $templateClass = null, ImagePipe $imagePipe, LinkGenerator $linkGenerator, Settings $settings)
	{
		parent::__construct($latteFactory, $httpRequest, $user, $cacheStorage, $templateClass);
		$this->support       = $support;
		$this->siteName      = $siteName;
		$this->imagePipe     = $imagePipe;
		$this->linkGenerator = $linkGenerator;
		$this->webSettings   = $settings->getAll();
	}

	public function createTemplate(UI\Control $control = null)
	{
		$template = parent::createTemplate($control);

		$template->_imagePipe    = $this->imagePipe;
		$template->linkGenerator = $this->linkGenerator;
		$template->support       = $this->support;
		$template->siteName      = $this->siteName;
		$template->adminAssets   = '/' . ASSETS_FOLDER . '/admin';
		$template->frontAssets   = '/' . ASSETS_FOLDER . '/front';
		$template->frontImages   = $template->frontAssets . '/img';
		$template->webSettings   = $this->webSettings;
		$year                    = date('Y');
		$template->pshkCopyright = '<div id="pshk-copyright">&copy; 2018' . ($year != 2018 ? ' - ' . $year : '') . ' by <a href="https://www.pshk.cz" target="_blank">PSHK s.r.o.</a></div>';

		return $template;
	}
}
