<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Components\FilesManager\FilesManager as FilesManagerComponent;
use Core\Model\FilesManager\FilesManager;
use Nette\DI\Container;
use Nette\Http\Request;
use Nette\Http\Session;
use Nette\Utils\Html;

class FilesManagerInput extends TextInput
{
	/** @var FilesManager */
	public $filesManager;

	/** @var Container */
	private $container;

	/** @var FilesManagerComponent */
	private $controller;

	/** @var string */
	private $controllerName;

	public function __construct($caption = null, FilesManager $filesManager, Session $session, Request $request)
	{
		parent::__construct($caption);
		$this->filesManager = $filesManager;
		$this->controller   = new FilesManagerComponent($this->filesManager, $session, $request);
	}

	protected function attached($form)
	{
		parent::attached($form);
		$this->controllerName = 'filesManagerController' . ucfirst($this->name);
		$currGroup            = $this->getForm()->getCurrentGroup();

		$this->getForm()->setCurrentGroup(null);
		$this->form->addComponent($this->controller, $this->controllerName);
		$this->getForm()->setCurrentGroup($currGroup);
	}

	public function getControl($content = null)
	{
		$this->controller->setModal();
		$wrapper = Html::el('div', ['class' => 'filemanager-control']);
		$input   = parent::getControl();
		$inputId = $input->getAttribute('id');
		$input->setAttribute('type', 'hidden');

		$btnThumbnail = Html::el('a', ['href' => '#', 'target' => '_blank', 'class' => 'btn btn-info', 'id' => $inputId . '-thumbnail'])
			->addHtml('<i class="fa fa-file"></i>');
		$fakeInput    = Html::el('input type=text readonly=true', ['class' => 'form-control', 'id' => $inputId . '-fake-input']);

		$btns = Html::el('div', ['class' => 'btn-group']);

		$btn = Html::el('a', [
			'href'  => $this->controller->link('showModal!', [$this->controllerName]),
			'class' => 'ajax btn btn-success',
		]);
		$btn->setHtml($content === null ? $this->translate('default.select') : $content);

		$btnDelete = Html::el('a', ['href' => '#', 'class' => 'btn btn-danger btn-remove-image-' . $inputId])->addHtml('<i class="fa fa-times"></i>');

		$btns->addHtml($btnThumbnail);
		$btns->addHtml($fakeInput);
		$btns->addHtml($btn);
		$btns->addHtml($btnDelete);


		ob_start();
		$this->controller->render();
		$content = ob_get_clean();

		$latte = file_get_contents(__DIR__ . '/FileManagerInput.latte');
		$latte = str_replace('{$inputId}', $inputId, $latte);
		$latte = str_replace('{$controllerName}', $this->controllerName, $latte);

		$wrapper->addHtml($btns);
		$wrapper->addHtml($content);
		$wrapper->addHtml($latte);
		$wrapper->addHtml($input);

//		$img = Html::el('img', ['src' => '', 'style' => 'max-width: 250px;', 'class' => 'image-preview-' . $inputId]);
//		$wrapper->addHtml($img);

		if ($this->getValue()) {
			$btnThumbnail->attrs['href'] = $this->getValue();
			$fakeInput->attrs['value']   = $this->getValue();
//			$img->src                    = $this->getValue();
		} else {
//			$img->style       .= ' display: none;';
			$btnDelete->style = ' display: none;';
		}

		return $wrapper;
	}

	public function setContainer(Container $container)
	{
		$this->container = $container;
	}

	public static function register(\Nette\DI\Container $systemContainer)
	{
		$class = __CLASS__;
		\Nette\Forms\Container::extensionMethod("addFilesManager", function(
			\Nette\Forms\Container $container, $name, $caption
		) use ($class, $systemContainer) {
			/** @var FilesManagerInput $comp */
			$comp = new $class($caption,
				$systemContainer->getByType(FilesManager::class, false),
				$systemContainer->getByType(Session::class, false),
				$systemContainer->getByType(Request::class, false));

			$comp->container = $systemContainer;

			$container->addComponent($comp, $name);

			return $comp;
		});
	}
}