<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Nette\Utils\Html;

/**
 * Trait TInputExtend
 * @package Core\Model\UI\Form\Traits
 */
trait TInputExtend
{
	/** @var string */
	public $description;

	/** @var bool */
	public $isMultiLanguage = false;

	/**
	 * @param $description
	 *
	 * @return $this
	 */
	public function setDescription($description)
	{
		$this->description = $description;

		return $this;
	}

	/**
	 * @param bool $val
	 *
	 * @return $this
	 */
	public function setIsMultilanguage($val = true)
	{
		$this->isMultiLanguage = $val;

		return $this;
	}

	/**
	 * @return mixed
	 */
	public function getDescription() { return $this->getTranslator()->translate($this->description); }

	protected function getIsMultiLanguage() { return $this->getForm(false)->langsService && $this->isMultiLanguage; }

	protected function createTranslatableControl($control)
	{
		if ($this->getIsMultiLanguage()) {
			$wrap        = Html::el('div');
			$langs       = $this->getForm()->langsService->getLangs();
			$defaultLang = array_shift($langs);
			foreach ($langs as $k => $lang) {
				$c = clone $control;

				// TODO předělat a upravit taky aby bylo povinné pouze jedno pole
				if ($defaultLang->getTag() != $lang->getTag()) {
					unset($c->attrs['required']);

					foreach ($c->attrs['data-nette-rules'] as $k => $rule) {
						if ($rule['op'] == ':filled')
							unset($c->attrs['data-nette-rules'][$k]);
						break;
					}
				}

				$c->attrs['name']              .= "[$k]";
				$c->attrs['id']                .= "-$k";
				$c->attrs['data-content-lang'] = $k;
				if ($c->getName() == 'textarea')
					$c->setText($this->getValue()[$k] ?? '');
				else
					$c->attrs['value'] = $this->getValue()[$k] ?? '';

				$wrap->addHtml($c);
			}

			return $wrap;
		}

		return $control;
	}

	/**
	 * Loads HTTP data.
	 * @return mixed
	 */
	protected function getHttpData($type, $htmlTail = null)
	{
		if ($this->getIsMultiLanguage())
			return array_map(function($lang) use ($type, $htmlTail) {
				return $this->getForm()->getHttpData($type, $this->getHtmlName() . "[{$lang->getTag()}]" . $htmlTail);
			}, $this->getForm()->langsService->getLangs(false));
		else
			return $this->getForm()->getHttpData($type, $this->getHtmlName() . $htmlTail);
	}
}
