import {slideDown, slideUp} from "es6-slide-up-down";

document.addEventListener('DOMContentLoaded', () => {
	const hamburgerIcon  = document.getElementById('hamburger');
	const responsiveMenu = document.querySelector('.mobil-navigation');

	hamburgerIcon.addEventListener('click', () => {
		if (!responsiveMenu.classList.contains('active')) {
			slideDown(responsiveMenu);
			responsiveMenu.classList.add('active');
			hamburgerIcon.classList.add('top-menu__hamburger--active');
		} else {
			slideUp(responsiveMenu);
			responsiveMenu.classList.remove('active');
			hamburgerIcon.classList.remove('top-menu__hamburger--active');
		}
	});

	document.addEventListener('click', e => {
		const target = e.target;
		let el       = null;

		/**
		 * Ovladani responzivni menu
		 */
		el = target.closest('[data-open-responsive-sub]');
		if (el !== null) {
			const id        = el.dataset.openResponsiveSub;
			const submenuEl = document.querySelector(`[data-responsive-sub="${id}"]`);

			if (submenuEl.classList.contains('mobil-sub-navigation__list--active')) {
				slideUp(submenuEl);
				submenuEl.classList.remove('mobil-sub-navigation__list--active');
				el.classList.remove('active');

			} else {
				slideDown(submenuEl);
				submenuEl.classList.add('mobil-sub-navigation__list--active');
				el.classList.add('active');
			}
		}
	});
})
