/**
 * SVG icons
 */
let loadedIcons    = [];
let startedRequest = [];

const loadSvgIcons = () => {
	document.querySelectorAll('[data-svg-icon]').forEach(el => {
		let XMLrequest = new XMLHttpRequest();
		XMLrequest.open("GET", '/assets/front/img/icons/' + el.dataset.svgIcon + '.svg', true); // URL of the SVG file on server
		XMLrequest.send(null);
		el.removeAttribute('data-svg-icon');
		XMLrequest.onload = function (e) {
			el.removeAttribute('data-svg-icon');
			if (el.dataset.replace !== undefined)
				el.outerHTML = XMLrequest.responseText;
			else
				el.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
		}
	});
	document.querySelectorAll('[data-svg-icon-pshk]').forEach(el => {
		const iconName = el.dataset.svgIconPshk;
		if (loadedIcons[iconName]) {
			el.removeAttribute('data-svg-icon-pshk');

			if (el.dataset.replace !== undefined)
				el.outerHTML = loadedIcons[iconName];
			else
				el.insertAdjacentHTML('afterbegin', loadedIcons[iconName]);
		} else {
			if (startedRequest[iconName])
				return;

			startedRequest[iconName] = true;

			let XMLrequest = new XMLHttpRequest();
			XMLrequest.open("GET", 'https://assets.pshk.cz/icons/' + iconName + '.svg', true); // URL of the SVG file on server
			XMLrequest.send(null);
			XMLrequest.onload = function (e) {
				document.querySelectorAll('[data-svg-icon-pshk="'+iconName+'"]').forEach(iconEl => {
					iconEl.removeAttribute('data-svg-icon-pshk');
					loadedIcons[iconName] = XMLrequest.responseText;
					if (iconEl.dataset.replace !== undefined)
						iconEl.outerHTML = XMLrequest.responseText;
					else
						iconEl.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
				});
			}
		}
	});
	document.querySelectorAll('[data-svg-img]').forEach(el => {
		let XMLrequest = new XMLHttpRequest();
		XMLrequest.open("GET", el.dataset.svgImg, true); // URL of the SVG file on server
		XMLrequest.send(null);
		el.removeAttribute('data-svg-icon');
		XMLrequest.onload = function (e) {
			el.removeAttribute('data-svg-img');
			if (el.dataset.replace !== undefined)
				el.outerHTML = XMLrequest.responseText;
			else
				el.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
		}
	});
}

loadSvgIcons();

global.naja.addEventListener('complete', e => {
	loadSvgIcons();
});

/**
 * Last clicked element
 */
global.naja.addEventListener('start', e => {
	global.lastClicked = document.activeElement;
});

/**
 * Ajax content replace
 */
global.naja.addEventListener('complete', e => {
	// Automatická změna titulku pokud proběhne ajax a je potřeba ho změnit
	if (e.response && e.response.pageTitle)
		document.title = e.response.pageTitle;

	// Aktualizace html elementu podle response
	if (e.response && e.response.ajaxPlaceholders) {
		for (let [key, value] of Object.entries(e.response.ajaxPlaceholders)) {
			document.querySelectorAll('[data-ajax-placeholder="' + key + '"').forEach(el => {
				el.innerHTML = value;
			})
		}
	}
});
