import {addEventForChild} from './utils/utilities';

document.addEventListener('DOMContentLoaded', () => {
	const darker = document.querySelector('.darker');
	const body   = document.querySelector('body');

	if (darker) {
		addEventForChild(body, 'click', '[data-modal]', el => {
			const modalTarget = el.dataset.modal;
			if (modalTarget) {
				document.querySelectorAll(modalTarget).forEach(el => el.classList.add('modal--active'));
			}
			darker.classList.add('darker--active');
		});

		darker.addEventListener('click', () => {
			document.querySelectorAll('.modal').forEach(el => {
				document.documentElement.classList.remove('overflow-hidden');
				document.querySelectorAll('.modal').forEach(el => {
					el.classList.remove('modal--active');
					if (el.dataset.destroyOnClose === 'true')
						el.remove();
				});
				darker.classList.remove('darker--active');
			});
		});

		addEventForChild(body, 'click', '.modal__close, [data-modal-close]', el => {
			document.documentElement.classList.remove('overflow-hidden');
			document.querySelectorAll('.modal').forEach(el => {
				el.classList.remove('modal--active')
				if (el.dataset.destroyOnClose === 'true')
					el.remove();
			});
			darker.classList.remove('darker--active');
		});
	}
});

global.naja.addEventListener('success', (e) => {
	if (!e.response || e.response.createModalData === undefined)
		return;

	const data   = e.response.createModalData;
	const darker = document.querySelector('.darker');


	let modalWrap = document.createElement('div');
	modalWrap.classList.add('modal', 'modal--active');
	modalWrap.dataset.destroyOnClose = true;

	if (data.modalClass)
		modalWrap.classList.add(data.modalClass);

	if (data.title) {
		let modalTitleWrap = document.createElement('div');
		modalTitleWrap.classList.add('modal__header');

		let modalTitleText       = document.createElement('span');
		modalTitleText.innerHTML = data.title;

		let modalTitleClose = document.createElement('div');
		modalTitleClose.classList.add('modal__close');

		modalTitleWrap.append(modalTitleText, modalTitleClose);
		modalWrap.append(modalTitleWrap);
	}

	if (data.text) {
		let modalBodyWrap = document.createElement('div');
		modalBodyWrap.classList.add('modal__body-wrap');

		let modalBody = document.createElement('div');
		modalBody.classList.add('modal__body');

		let modalBodyInner = document.createElement('div');
		modalBodyInner.classList.add('inner');
		modalBodyInner.innerHTML = data.text;

		modalBody.append(modalBodyInner);
		modalBodyWrap.append(modalBody);
		modalWrap.append(modalBodyWrap);
	}

	document.body.append(modalWrap);
	darker.classList.add('darker--active');
});
