export class LoaderExtension {
	constructor(naja, loaderSelector) {
		this.loaderSelector = loaderSelector;

		naja.addEventListener('start', this.showLoader.bind(this));
		naja.addEventListener('complete', this.hideLoader.bind(this));
		naja.addEventListener('error', this.hideLoader.bind(this));
	}

	showLoader() {
		this.getLoader().style.display = 'block';
	}

	hideLoader() {
		this.getLoader().style.display = 'none';
	}

	getLoader() {
		if (!this.loader)
			this.loader = document.querySelector(this.loaderSelector);

		return this.loader;
	}
}
