<?php declare(strict_types = 1);

namespace Core\Components\Flashes;

use Core\Model\UI\BaseControl;
use Nette;

class Flashes extends BaseControl
{
	const FLASH_PRIMARY   = 'primary';
	const FLASH_SECONDARY = 'secondary';
	const FLASH_SUCCESS   = 'success';
	const FLASH_DANGER    = 'danger';
	const FLASH_WARNING   = 'warning';
	const FLASH_INFO      = 'info';

	public function render(array $parameters = null)
	{
		if ($parameters) {
			$this->template->parameters = Nette\Utils\ArrayHash::from($parameters);
		}

		$flashes                 = $this->getPresenter()->getTemplate()->flashes ?: $this->getPresenter()->getFlashSession()->flash;
		$this->template->flashes = $flashes;
		$this->template->render($this->getTemplateFile());
	}
}
