<?php declare(strict_types = 1);

namespace Core\Components\Header;

use Core\FrontModule\Model\SeoParser;
use Core\Model\UI\BaseControl;

/**
 * Class Meta
 * @package Core\Components\Header
 */
class Meta extends BaseControl
{
	/** @var array */
	protected $metas = [];

	/** @var array */
	protected $otherHeaders = [];

	/** @var SeoParser */
	protected $seoParserService;

	public function __construct(SeoParser $seoParser)
	{
		$this->seoParserService = $seoParser;
	}

	public function render()
	{
		$metas = $this->getMeta();

		if (isset($metas['canonical'])) {
			$canonical = $metas['canonical']['value'] == 'self'
				? $this->getPresenter()->link('//this')
				: $metas['canonical']['value'];
			unset($metas['canonical']);
		} else {
			$canonical = $this->getPresenter()->link('//this');
		}

		$this->template->canonical    = $canonical;
		$this->template->metas        = $metas;
		$this->template->otherHeaders = $this->otherHeaders;

		$this->template->setFile(__DIR__ . '/Meta.latte');
		$this->template->render();
	}

	/*******************************************************************************************************************
	 * ======================== GET
	 */

	public function getMeta($key = null)
	{
		$metas = $this->metas;

		if ($key)
			$metas = $metas[$key] ?? [];

		return $key && isset($metas[$key]) ? $metas[$key] : $metas;
	}

	/*******************************************************************************************************************
	 * ======================== SET
	 */

	/**
	 * @param        $key
	 * @param        $value
	 * @param string $attribute
	 *
	 * @return $this
	 */
	public function setMeta($key, $value, $attribute = 'name')
	{
		$this->metas[$key] = [
			'key'       => $key,
			'value'     => $this->seoParserService->parse($value),
			'attribute' => $attribute,
		];

		return $this;
	}

	/**
	 * @param string $string
	 *
	 * @return $this
	 */
	public function setOtherHeader(string $string)
	{
		$this->otherHeaders[] = $string;

		return $this;
	}

	public function disableIndexing()
	{
		//		$this->setMeta('robots', 'noindex, follow');

		return $this;
	}

	public function setRobotsIndex($value = 'index')
	{
		$this->robots['index'] = $value;

		return $this;
	}

	/*******************************************************************************************************************
	 * ======================== Getters
	 */

}
