<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="core__country")
 * @ORM\Entity
 */
class Country
{

	/**
	 * @var string
	 *
	 * @ORM\Id
	 * @ORM\Column(name="`id`", type="string", length=255, nullable=false)
	 */
	public $id;

	/**
	 * @var string
	 * @ORM\Column(name="`name`", type="string", length=255, nullable=true)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="iso3166_1", type="string", length=3, nullable=false, options={"default": "CZE"})
	 */
	protected string $iso3166_1 = 'CZE';

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected $position;

	/**
	 * Country constructor.
	 *
	 * @param string $id
	 * @param string $name
	 * @param string $iso3166_1
	 */
	public function __construct(string $id, string $name, string $iso3166_1)
	{
		$this->id        = $id;
		$this->name      = $name;
		$this->iso3166_1 = $iso3166_1;
		$this->setPosition(-1);
	}

	public function getId()
	{
		return $this->id;
	}

	public function getName()
	{
		return $this->name;
	}

	public function setName($name): Country
	{
		$this->name = $name;

		return $this;
	}

	public function getPosition()
	{
		return $this->position;
	}

	public function setPosition($position): Country
	{
		$this->position = $position;

		return $this;
	}

	public function getIso3166_1(): string { return strtoupper($this->iso3166_1); }

	public function setIso3166_1(string $iso3166_1): self
	{
		$this->iso3166_1 = $iso3166_1;

		return $this;
	}
}
