<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Core\Model\ORM\Query;
use Nettrine\ORM\EntityManagerDecorator as NettrineEM;
use Doctrine\ORM\Query as DoctrineQuery;

/**
 * Class EntityManagerDecorator
 * @package Core\Model\Entities
 *
 * @method EntityRepository getRepository($className)
 */
class EntityManagerDecorator extends NettrineEM
{
	public static bool $useDoctrineQuery = false;

	public function clear($objectName = null)
	{
		if (is_array($objectName))
			foreach ($objectName as $obj)
				parent::clear($obj);
		else
			parent::clear($objectName);
	}

	public function persist($object): self
	{
		parent::persist($object);

		return $this;
	}

	public function createQueryBuilder()
	{
		return new QueryBuilder($this);
	}

	public function createQuery($dql = '')
	{
		if (self::$useDoctrineQuery)
			$query = new DoctrineQuery($this);
		else
			$query = new Query($this);

		if (!empty($dql)) {
			$query->setDQL($dql);
		}

		return $query;
	}
}
