<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine;
use Doctrine\ORM\AbstractQuery;

class EntityRepository extends \Doctrine\ORM\EntityRepository
{
	public function findPairs($criteria, $value = null, $orderBy = [], $key = null)
	{
		if (!is_array($criteria)) {
			$key      = $orderBy;
			$orderBy  = $value;
			$value    = $criteria;
			$criteria = [];
		}

		if (!is_array($orderBy)) {
			$key     = $orderBy;
			$orderBy = [];
		}

		if (empty($key)) {
			$key = $this->getClassMetadata()->getSingleIdentifierFieldName();
		}

		$qb    = $this->createQueryBuilder('e')
			->whereCriteria($criteria)
			->select(["e.$value", "e.$key"])
			->resetDQLPart('from')->from($this->getEntityName(), 'e', 'e.' . $key);
		$query = $qb->autoJoinOrderBy($orderBy)->getQuery();

		try {
			return array_map(function($row) {
				return reset($row);
			}, $query->getResult(AbstractQuery::HYDRATE_ARRAY));
		} catch (\Exception $e) {
			throw $this->handleException($e, $query);
		}
	}

	public function getReference($id)
	{
		/** @var Doctrine\ORM\Proxy\Proxy|null $reference */
		$reference = $this->getEntityManager()->getReference($this->_entityName, $id);

		return $reference;
	}

	public function createQueryBuilder($alias, $indexBy = null)
	{
		return (new QueryBuilder($this->_em))
			->select($alias)
			->from($this->_entityName, $alias, $indexBy);
	}
}
