<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Control;
use Nette\Application\UI\ITemplate;
use Symfony\Contracts\EventDispatcher\Event;

class CreateFormEvent extends Event
{
	/** @var BaseForm */
	public $form;

	/** @var ITemplate */
	public $template;

	public ?Control $control = null;

	public function __construct(BaseForm $form, ?ITemplate $template)
	{
		$this->form = $form;
		if ($template)
			$this->template = &$template;
	}
}
