<?php declare(strict_types=1);

namespace Core\Model\Helpers;

class CssHelper
{
	/**
	 * @param string $css
	 * @return string[]
	 */
	public static function parse(string $css): array
	{
		$result = [];
		preg_match_all('/\s*([-\w]+)\s*:?\s*(.*?)\s*;/m', $css,$m);
		for ($i = 0, $count = count($m[1]); $i < $count; $i++) {
			$result[$m[1][$i]] = $m[2][$i];
		}
		return $result;
	}
}