<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\Helpers\Strings;
use Nette;

class Route extends \Nette\Application\Routers\Route
{
	public function __construct($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if ($locale) {
			$mask = '/[<locale=' . $locale . ' [a-z]{2}>/]' . ltrim($mask, '/');
		}

		parent::__construct($mask, $metadata, $flags);
	}

	public function constructUrl(array $params, Nette\Http\UrlScript $refUrl): ?string
	{
		if (isset($params['presenter']) && Strings::contains($params['presenter'], 'Override')) {
			$metadata = $this->getMetadata();
			if (isset($metadata['presenter']['value']) && $metadata['presenter']['value'] !== $params['presenter']) {
				$params['presenter'] = str_replace('Override', '', $params['presenter']);
			}
		}

		return parent::constructUrl($params, $refUrl);
	}

}
