<?php declare(strict_types = 1);

namespace Core\Model\Templating\Macros;

use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;
use Nette\Utils\Json;

final class TemplateText extends MacroSet
{
	public static function install(Compiler $compiler)
	{
		$self = new self($compiler);
		$self->addMacro('templateText', [$self, 'macroTemplateText']);
		$self->addMacro('tt', [$self, 'macroTemplateText']);
		$self->addMacro('templateTextR', [$self, 'macroTemplateTextR']);
		$self->addMacro('ttR', [$self, 'macroTemplateTextR']);
	}

	public function macroTemplateText(MacroNode $node, PhpWriter $writer)
	{
		$oData = self::parseInputAttrs($node->args);

		if (!isset($oData['name']))
			return '';

		if (isset($oData['toVar']))
			$str = '${"' . str_replace('"', "'", $oData['toVar']) . '"} = ';
		else
			$str = 'echo ';

		$data = $this->prepareData($oData, "'");

		$str .= '$this->global->templateText->render("' . ($data['type'] ?? 'text') . '", $templateTextValues["' . $oData['name'] . '"] ?? "", \'' . Json::encode($data, JSON_HEX_APOS | JSON_HEX_QUOT) . '\')';

		return $writer->write($str);
	}

	public function macroTemplateTextR(MacroNode $node, PhpWriter $writer)
	{
		$data = self::parseInputAttrs($node->args);
		$data = $this->prepareData($data);

		$str = 'echo \'{tt';
		foreach ($data as $k => $v) {
			$str .= ' ' . $k . '="' . $v . '"';
		}

		$str .= '}\'';

		return $writer->write($str);
	}

	private function prepareData(array $data, $quotes = "'")
	{
		$re = '/{\$([^}]+)}/';
		foreach ($data as $k => $v) {
			preg_match_all($re, $v, $matches, PREG_OFFSET_CAPTURE, 0);

			foreach ($matches as $mk => $match) {
				$data[$k] = str_replace($matches[0][$mk][0], $quotes . " . $" . $matches[1][$mk][0] . " . " . $quotes, $data[$k]);
			}

			if ($k === 'items') {
				$data[$k] = str_replace("'", "\'", $v);
			}
		}

		return $data;
	}

	public static function parseInputAttrs($str)
	{
		$re  = '/(\w+)="(.*)"/U';
		$arr = [];
		preg_match_all($re, $str, $matches, PREG_SET_ORDER, 0);
		foreach ($matches as $match) {
			if (isset($match[1]) && isset($match[2]))
				$arr[$match[1]] = $match[2];
		}

		return $arr;
	}
}
