<?php declare(strict_types = 1);

namespace Core\Model\UI;

use Core\Components\JsTranslates\IJsTranslatesFactory;
use Core\Components\JsTranslates\JsTranslates;
use Core\Model\Event\ControlEvent;
use Core\Model\UI\Traits\TPresenterComponentPack;

abstract class FrontPresenter extends AbstractPresenter
{
	use TPresenterComponentPack;

	public array $breadcrumbsBefore = [];
	public array $breadcrumbsAfter  = [];

	protected function startup()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::startup');
		parent::startup();
	}

	public function beforeRender()
	{
		$this->componentsPack['head'][] = $this['jsTranslates'];
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::beforeRender');
		parent::beforeRender();
	}

	protected function createComponentJsTranslates(IJsTranslatesFactory $factory): JsTranslates { return $factory->create(); }
}
