import {tns} from "tiny-slider/src/tiny-slider";

export const PromoteApplet = (promoteAppletSlider) => {
	if (promoteAppletSlider) {
		const slider = tns({
			container           : promoteAppletSlider,
			items               : 1,
			controls            : false,
			autoplay            : true,
			autoplayTimeout     : 5000,
			edgePadding         : 0,
			mouseDrag           : true,
			autoplayButtonOutput: false,
			autoplayHoverPause  : true,
		});

		slider.events.on('indexChanged', (el) => {
			const realIndex   = el.displayIndex;
			let activeElement = setActiveSliderItem(realIndex);

			let url   = null;
			let slide = el.slideItems[realIndex];

			if (slide !== undefined) {
				let slideA = slide.querySelector('a');
				if (slideA) {
					url = slideA.href;
				}

				var inViewport = isInViewport(slide);
				if (inViewport) {
					dispatchSlideView(realIndex, activeElement ? activeElement.textContent.trim() : null, url);
				}
			}
		});

		document.querySelector('.promote-applet__arrow--right').addEventListener('click', () => {
			slider.pause();
			slider.goTo('next');
		});

		document.querySelector('.promote-applet__arrow--left').addEventListener('click', () => {
			slider.pause();
			slider.goTo('prev');
		});

		/**
		 * Ovladani slideru pomoc menu
		 */
		const promoteAppletMenuItems = document.querySelectorAll('.promote-applet__menu-item');
		promoteAppletMenuItems.forEach((el) => {
			el.addEventListener('click', () => {
				const id = parseInt(el.dataset.id) - 1;
				slider.pause();
				slider.goTo(id);
			});
		});

		const getSlideUrl = (slide) => {
			let link = slide.querySelector('a');
			return link ? link.href : null;
		}

		const getMenuText = (item) => {
			return item ? item.textContent.trim() : null;
		}

		setTimeout(function () {
			let slide = promoteAppletSlider.querySelector('.tns-item:not(.tns-slide-cloned)');

			if (slide && promoteAppletMenuItems[0]) {
				dispatchSlideView(1, getMenuText(promoteAppletMenuItems[0]), getSlideUrl(slide));
			}
		}, 100);

		promoteAppletSlider.addEventListener('click', e => {
			let target = e.target;

			if (target.tagName !== 'A') {
				target = target.closest('a');
			}

			if (target && target.tagName === 'A') {
				try {
					let slide = target.closest('.tns-item');
					let index = 1;

					while (
						(slide = slide.previousElementSibling)
						&& slide.classList.contains('tns-slide-cloned') === false
						) {
						index++;
					}

					dispatchSlideClick(index, getMenuText(promoteAppletMenuItems[index - 1]), getSlideUrl(slide));
				} catch (e) {
				}

				e.preventDefault();
				setTimeout(function () {
					window.location = target.href;
				}, 125);
			}
		});
	}
};

const isInViewport = (ele) => {
	const {top, bottom} = ele.getBoundingClientRect();
	const vHeight       = (window.innerHeight || document.documentElement.clientHeight);

	return (
		(top > 0 || bottom > 0) &&
		top < vHeight
	);
};

const setActiveSliderItem = (id) => {
	const promoteAppletMenuItems = document.querySelectorAll('.promote-applet__menu-item');
	promoteAppletMenuItems.forEach(el => el.classList.remove('primary-bg-color'));
	const activeElement = document.querySelector(`.promote-applet__menu-item[data-id="${id}"]`);
	activeElement.classList.add('primary-bg-color');

	return activeElement;
};

const dispatchSlideView = (position, name, url) => {
	let event = new CustomEvent('slideView', {
		detail: {
			position: position,
			name    : name,
			url     : url,
		},
	});

	document.dispatchEvent(event);
}

const dispatchSlideClick = (position, name, url) => {
	let event = new CustomEvent('slideClick', {
		detail: {
			position: position,
			name    : name,
			url     : url,
		},
	});

	document.dispatchEvent(event);
}
